/*
 * Decompiled with CFR 0.152.
 */
package core.modes;

import core.GameWindow;
import core.Sprite;
import core.modes.SurvivalGameMode;
import core.states.GameState;
import entities.creatures.enemies.LuxEntity;
import entities.creatures.enemies.MinionEntity;
import entities.creatures.enemies.SivirEntity;
import entities.missiles.misc.EzrealUltiEntity;
import util.Config;
import util.ResourceManager;

public class StoryGameMode
extends SurvivalGameMode {
    private LuxEntity lux = null;
    private SivirEntity sivir = null;
    private boolean ezrealUltiLevel;
    private boolean sorakaUltiLevel;
    private boolean luxLevel;
    private boolean sivirLevel;
    private boolean ezrealUltiDone = false;
    private boolean sorakaUltiDone = false;
    private long sorakaUltiStartTime = 0L;
    private Sprite luxSprite;
    private Sprite arrowDown = ResourceManager.get().getSprite("interface/arrow_down");

    public StoryGameMode(GameState gamestate) {
        super(gamestate);
        this.luxSprite = ResourceManager.get().getSprite("creatures/lux");
    }

    @Override
    public void startScreen() {
        this.window.drawText(GameWindow.FONT_MENU, this.width / 2, 120.0f, "Lux keeps laughing about Sona because\nshe is a weak supporter...\nHelp Sona to level up to 30\nto be strong enough to defeat Lux\nin a 1v1 duel of mages!", 2);
        this.luxSprite.draw(this.width / 2 - this.luxSprite.getWidth() / 2, 320);
    }

    private void prepareLuxEntity() {
        this.lux = new LuxEntity(this.gamestate, 375, 50);
        if (!this.gamestate.getEntities().contains(this.lux)) {
            this.gamestate.addEntity(this.lux);
        }
    }

    private void prepareSivirEntity() {
        this.sivir = new SivirEntity(this.gamestate, 375, 50);
        if (!this.gamestate.getEntities().contains(this.sivir)) {
            this.gamestate.addEntity(this.sivir);
        }
    }

    @Override
    public void startLevel() {
        this.level = this.gamestate.getLevel();
        this.ezrealUltiLevel = this.level == 20;
        this.sorakaUltiLevel = this.level == 30;
        this.sivirLevel = this.level == 31;
        this.luxLevel = this.level == 30 || this.level == 31;
        if (this.luxLevel) {
            this.prepareLuxEntity();
        } else {
            this.lux = null;
        }
        if (this.sivirLevel) {
            this.prepareSivirEntity();
        } else {
            this.sivir = null;
        }
        if (this.ezrealUltiLevel) {
            this.ezrealUltiDone = false;
        }
        if (this.sorakaUltiLevel) {
            this.sorakaUltiDone = false;
        }
        this.sorakaUltiStartTime = 0L;
        if (!this.luxLevel && !this.sivirLevel) {
            this.buildMinions();
            if (this.ezrealUltiLevel) {
                int row = Math.min(Config.get(Config.minionRows) + (int)(Config.get(Config.minionRowsPerLevel) * (float)this.level), Config.get(Config.minionRowsCap));
                while (row < Math.min(Config.get(Config.minionRows) + (int)(Config.get(Config.minionRowsPerLevel) * (float)this.level), Config.get(Config.minionRowsCap)) + Config.get(Config.minionEzrealExtraRows)) {
                    int x = 0;
                    while (x < Math.min(Config.get(Config.minionCols) + (int)(Config.get(Config.minionColsPerLevel) * (float)this.level), Config.get(Config.minionColsCap))) {
                        MinionEntity minion = new MinionEntity(this.gamestate, 100 + x * 49, 10 + row * 30);
                        minion.setCanShoot(false);
                        minion.setSpeedUp(false);
                        this.gamestate.addEntity(minion);
                        if (this.random.nextInt(Config.get(Config.superminionAppearChance) + Config.get(Config.superminionAppearChancePerLevel) * this.level) > 100000) {
                            minion.makeSuperminion();
                        }
                        ++x;
                    }
                    ++row;
                }
            }
        }
    }

    @Override
    public void render(long delta) {
        if (!this.luxLevel && !this.sivirLevel) {
            this.drawEnemyCount();
        }
        if (!this.gamestate.isWaitingForKeyPress()) {
            if (!this.ezrealUltiDone && this.ezrealUltiLevel && this.gamestate.getLevelStartTime() + 2000L <= this.gamestate.getTime()) {
                this.ezrealUltiDone = true;
                EzrealUltiEntity ezulti = new EzrealUltiEntity(this.gamestate, -500, 240);
                this.gamestate.addEntity(ezulti);
                ResourceManager.get().playSound("ezreal_ulti");
            }
            if (this.sorakaUltiLevel && (this.sorakaUltiStartTime == 0L || this.sorakaUltiStartTime + 1000L > this.gamestate.getTime()) && !this.sorakaUltiDone && this.sorakaUltiStartTime == 0L && this.lux.getHitpoints() <= Config.get(Config.sorakaUltiLuxHealthActivation)) {
                this.sorakaUltiStartTime = this.gamestate.getTime();
                this.lux.heal(Config.get(Config.sorakaUltiHealAmount));
                this.lux.addEffect("healSorakaUlti", this.sorakaUltiStartTime + 1000L);
                this.sorakaUltiDone = true;
                ResourceManager.get().playSound("soraka_ulti");
            }
            switch (this.level) {
                case 1: {
                    this.window.drawText(GameWindow.FONT_MAIN, this.width / 2, 170.0f, "You can move by using the arrow keys\nand fire autoattacks by pressing Space.", 2);
                    this.window.drawText(GameWindow.FONT_MAIN, this.width - 10, 410.0f, "Defeat all enemies in a level to reach the next level.", 3);
                    this.arrowDown.draw(590, 450);
                    break;
                }
                case 2: {
                    this.window.drawText(GameWindow.FONT_MAIN, this.width / 2, 170.0f, "Press Escape to pause the game and get an overview over your abilities.\n\nUse the Q, W, E and R keys to use them.", 2);
                    this.window.drawText(GameWindow.FONT_MAIN, 320.0f, 375.0f, "You can look here to see if your abilities are ready.\nIf they are on cooldown, they're shown grey.", 2);
                    this.arrowDown.draw(320, 450);
                    break;
                }
                case 3: {
                    this.window.drawText(GameWindow.FONT_MAIN, this.width / 2, 170.0f, "Your abilities will become stronger with every level\nbut you will also get more and stronger enemies with every level!", 2);
                    this.window.drawText(GameWindow.FONT_MAIN, 10.0f, 410.0f, "These are your hitpoints. Make sure to keep an eye on them!");
                    this.arrowDown.draw(145, 450);
                    break;
                }
                case 4: {
                    this.window.drawText(GameWindow.FONT_MAIN, this.width / 2, 170.0f, "That's pretty much all you need to know.\nUse your abilities wisely and you should succeed.\nDon't give up!\n\nNow level yourself up to defeat Lux!", 2);
                }
            }
        }
    }

    @Override
    public void drawMessage() {
        if (this.level == 30 && this.gamestate.levelUpPending()) {
            this.window.drawText(GameWindow.FONT_MENU, this.width / 2, 120.0f, "Congratulations, you made it! \nYou leveled all the way up and\nin the end you were able to defeat Lux!\nNobody will call Sona weak anymore!\n\nBut wait.. Lux got Revive...\nand this time Sivir is rushing to help her!", 2);
        } else if (this.level == 31 && this.gamestate.levelUpPending()) {
            this.window.drawText(GameWindow.FONT_TITLE, this.width / 2, 20.0f, "M i n i o n  I n v a d e r s", 2);
            this.window.drawText(GameWindow.FONT_SMALL, this.width - 10, 535.0f, "A game by Daniel Figge", 3);
            this.window.drawText(GameWindow.FONT_MENU, this.width / 2, 120.0f, "Wow, you were even able to survive that gank!\nYou are worth being considered a full mage now!\n\nThanks for playing!\n\nYou can press Space to continue\nthe game in survival mode.\nHow far can you get?", 2);
        } else {
            super.drawMessage();
        }
    }

    @Override
    public void playerDead() {
        if (this.gamestate.isWaitingForKeyPress()) {
            return;
        }
        this.gamestate.increaseDeathCount();
        GameState.message.text = "You lost!\nPress Space to retry this level";
        GameState.message.x = this.width / 2;
        GameState.message.y = 245;
        this.gamestate.setWaitingForKeyPress(true);
        if (!(ResourceManager.get().isSoundPlaying("lux_abilityR") || ResourceManager.get().isSoundPlaying("lux_abilityR2") || ResourceManager.get().isSoundPlaying("lux_abilityR3") || ResourceManager.get().isSoundPlaying("level_lose") || ResourceManager.get().isSoundPlaying("lux_win") || ResourceManager.get().isSoundPlaying("lux_win2") || ResourceManager.get().isSoundPlaying("sivir_win"))) {
            if (this.sivirLevel) {
                ResourceManager.get().playSound("sivir_win");
            } else if (this.luxLevel) {
                ResourceManager.get().playSound(this.random.nextBoolean() ? "lux_win" : "lux_win2");
            } else {
                ResourceManager.get().playSound("level_lose");
            }
        } else {
            ResourceManager.get().playSound("level_lose");
        }
    }
}

